/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.TypeInfo;

final class SuperBlock {
    private int index;
    private int start;
    private int end;
    private int[] locals;
    private int[] stack;
    private boolean isInitialized;
    private boolean isInQueue;

    SuperBlock(int index2, int start, int end, int[] initialLocals) {
        this.index = index2;
        this.start = start;
        this.end = end;
        this.locals = new int[initialLocals.length];
        System.arraycopy(initialLocals, 0, this.locals, 0, initialLocals.length);
        this.stack = new int[0];
        this.isInitialized = false;
        this.isInQueue = false;
    }

    int getIndex() {
        return this.index;
    }

    int[] getLocals() {
        int[] copy2 = new int[this.locals.length];
        System.arraycopy(this.locals, 0, copy2, 0, this.locals.length);
        return copy2;
    }

    int[] getTrimmedLocals() {
        int last2;
        for (last2 = this.locals.length - 1; last2 >= 0 && this.locals[last2] == 0 && !TypeInfo.isTwoWords(this.locals[last2 - 1]); --last2) {
        }
        int size2 = ++last2;
        for (int i = 0; i < last2; ++i) {
            if (!TypeInfo.isTwoWords(this.locals[i])) continue;
            --size2;
        }
        int[] copy2 = new int[size2];
        int i = 0;
        int j = 0;
        while (i < size2) {
            copy2[i] = this.locals[j];
            if (TypeInfo.isTwoWords(this.locals[j])) {
                ++j;
            }
            ++i;
            ++j;
        }
        return copy2;
    }

    int[] getStack() {
        int[] copy2 = new int[this.stack.length];
        System.arraycopy(this.stack, 0, copy2, 0, this.stack.length);
        return copy2;
    }

    boolean merge(int[] locals2, int localsTop, int[] stack, int stackTop, ConstantPool pool) {
        if (!this.isInitialized) {
            System.arraycopy(locals2, 0, this.locals, 0, localsTop);
            this.stack = new int[stackTop];
            System.arraycopy(stack, 0, this.stack, 0, stackTop);
            this.isInitialized = true;
            return true;
        }
        if (this.locals.length == localsTop && this.stack.length == stackTop) {
            boolean localsChanged = this.mergeState(this.locals, locals2, localsTop, pool);
            boolean stackChanged = this.mergeState(this.stack, stack, stackTop, pool);
            return localsChanged || stackChanged;
        }
        throw new IllegalArgumentException("bad merge attempt");
    }

    private boolean mergeState(int[] current, int[] incoming, int size2, ConstantPool pool) {
        boolean changed = false;
        for (int i = 0; i < size2; ++i) {
            int currentType = current[i];
            current[i] = TypeInfo.merge(current[i], incoming[i], pool);
            if (currentType == current[i]) continue;
            changed = true;
        }
        return changed;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    public String toString() {
        return "sb " + this.index;
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    void setInitialized(boolean b) {
        this.isInitialized = b;
    }

    boolean isInQueue() {
        return this.isInQueue;
    }

    void setInQueue(boolean b) {
        this.isInQueue = b;
    }
}

